/******************************************************************************
                                                   COPYRIGHT (c) FREESCALE 2005  
                                                                           
 File Name          :    $RCSfile: S12XMMCV4.h,v $                         
                                                                           
 Current Revision :      $Revision: 1.0 $                                  
                                                                           
 PURPOSE: header file for S12X Module Mapping Control (MMC) registers      
                                                                                                                                                      
 DESCRIPTION:  Defines structures and types for memory control registers.  
                                               
                                                                           
 UPDATE HISTORY                                                            
 REV  AUTHOR     DATE        DESCRIPTION OF CHANGE                          
 ---  ------    --------     ---------------------                          
 1.0  r32151    01/09/05     - Initial coding based on S12XMMCV2.h                              


     *******************************************************************
     * File created by: Freescale East Kilbride MCD Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef S12XMMCV4_H        /*prevent duplicated includes */
#define S12XMMCV4_H

#include "S12_COMMON.h"


typedef union uMMCCTL0
  {
  tU08  byte;
  struct
    {
    tU08 cs0e0   :1;     /* chip select 0 enable */
    tU08 cs1e0   :1;     /* chip select 1 enable */     
    tU08 cs2e0   :1;     /* chip select 2 enable */
    tU08 cs3e0   :1;     /* chip select 3 enable */
    tU08 cs0e1   :1;     /* chip select 0 enable */
    tU08 cs1e1   :1;     /* chip select 1 enable */     
    tU08 cs2e1   :1;     /* chip select 2 enable */
    tU08 cs3e1   :1;     /* chip select 3 enable */
    }bit;
  }tMMCCTL0;

/*bit masks for MMCCTL0*/
#define CS0E0    0x01   
#define CS1E0    0x02
#define CS2E0    0x04
#define CS3E0    0x08
#define CS0E1    0x10   
#define CS1E1    0x20
#define CS2E1    0x40
#define CS3E1    0x80

typedef union uMODE
  {
  tU08  byte;
  struct
    {
    tU08        :5;     /* not used */
    tU08 moda   :1;     /* mode select A */     
    tU08 modb   :1;     /* mode select B */
    tU08 modc   :1;     /* mode select C */
    }bit;
  }tMODE;

/*bit masks for MODE*/
#define MODA    0x20    
#define MODB    0x40
#define MODC    0x80

typedef union uGPAGE
  {
  tU08   byte;
  struct
    {
    tU08 gp :7;         /*active page bits */
    tU08    :1;         /*not used */
    }bit;
  }tGPAGE;

typedef union uDIRECT
  {
  tU08   byte;
  struct
    {
    tU08 dp :8;         /*active page bits */
    }bit;
  }tDIRECT;


typedef union uMMCCTL1      
  {
  tU08   byte;
  struct
    {
    tU08 romon    :1;     /* ROM/Flash enable bit */
    tU08 romhm    :1;     /* ROM/Flash higher fixed page only */
    tU08 eromon   :1;     /* Emulation ROM on */
    tU08 ramhm    :1;     /* Top of RAM mapped to 0x7FFF */
    tU08 pgmifron :1;     /* Program Flash Information row visible */
    tU08 eeifron  :1;     /* EE information row visible */
    tU08 mgromon  :1;     /* EE state machine microcode visible */
    tU08 tmgramon :1;     /* EE Tag RAM visible */
    }bit;
  }tMMCCTL1;

/* bit masks for MMCCTL1 */
#define ROMON    0x01
#define ROMHM    0x02
#define EROMON   0x04
#define RAMHM    0x08
#define PGMIFRON 0x10
#define EEIFRON  0x20
#define MGROMON  0x40
#define TMGRAMON 0x80

typedef union uRPAGE
  {
  tU08   byte;
  struct
    {
    tU08 rp    :8;      /*active page bits */
    }bit;
  }tRPAGE;
  
typedef union uEPAGE
  {
  tU08   byte;
  struct
    {
    tU08 ep    :8;      /*active page bits */
    }bit;
  }tEPAGE;

typedef union uPPAGE
  {
  tU08   byte;
  struct
    {
    tU08 pix   :8;      /*active page bits */
    }bit;
  }tPPAGE;

#endif /*S12XMMCV4_H */